<?php

namespace App\Http\Controllers;

use App\Models\Member;
use App\Models\Ongkir;
use App\Models\Ongkirmember;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MemberController extends Controller
{
    public function index()
    {
        $member = Member::pencarian()->latest()->paginate(10);
        $data = [
            'title' => 'Ramizah Store | Member',
            'page' => 'Member',
            'menuActive' => 'member',
            'menuOpen' => 'member',
        ];
        return view('kasir.member.member', compact('data', 'member'))->with('no', 1);
    }

    public function tambah()
    {
        $kd = kodemember();
        $ongkir = Ongkir::latest()->get();
        $data = [
            'title' => 'Ramizah Store | Tambah Member',
            'page' => 'Tambah Member',
            'menuActive' => 'member',
            'menuOpen' => 'member',
        ];
        return view('kasir.member.tambah', compact('data', 'kd', 'ongkir'));
    }

    public function ongkir(Request $request)
    {
        $o = Ongkir::where('id', $request->id)->first();
        $data = [
            'alamat' => $o->rute,
            'berat' => $o->berat,
            'harga' => $o->harga,
        ];
        return response()->json($data);
    }

    public function store(Request $request): RedirectResponse
    {
        $request->validate(
            [
                'nm_member'         => 'required',
                'hp_member'         => 'required|unique:members,hp_member',
                'username'       => 'required|unique:members,username',
                'password'         => 'required|min:6',

                'kelamin_member'         => 'required',
                'alamat'         => 'required',
                'ongkir'         => 'required',
            ],
            [
                'required' => 'Form wajib diisi!',
                'unique' => 'Username sudah pernah diinputkan, silahkan input username lain!',
                'min' => 'Password minimal 6 digit!',
            ]
        );

        $id = Member::create([
            'kd_member'  => kodemember(),
            'nm_member'  => $request->nm_member,
            'hp_member'  => $request->hp_member,
            'email_member'  => $request->email_member,
            'kelamin_member'  => $request->kelamin_member,
            'username'  => $request->username,
            'password'  => bcrypt($request->password),
        ])->id;

        Ongkirmember::create([
            'user_id' =>  Auth::user()->id,
            'member_id' => $id,
            'ongkir_id' => $request->ongkir,
            'alamat' => $request->alamat,
            'sts_alamat' => 'Y',
        ]);

        return redirect()->route('member.index')->with(['success' => 'Data Berhasil Disimpan!']);
    }

    public function edit_member(Request $request)
    {
        $p = Member::where('id', $request->id)->first();
        $data = [
            'kode' => $p->kd_member,
            'nama' => $p->nm_member,
            'hp' => $p->hp_member,
            'email' => $p->email_member,
            'kelamin_member' => $p->kelamin_member,
            'username' => $p->username,
        ];
        return response()->json($data);
    }

    public function update_member(Request $request)
    {
        $member = Member::findOrFail($request->id);
        if ($request->password == 1) {
            $member->update([
                'nm_member'  => $request->nm_member,
                'hp_member'  => $request->hp_member,
                'email_member'  => $request->email_member,
                'kelamin_member'  => $request->kelamin,
                'username'  => $request->username,
            ]);
        } else {
            $member->update([
                'password'  => bcrypt($request->password),
            ]);
        }
        return response()->json();
    }


    public function edit_ongkir(Request $request)
    {
        $p = Ongkirmember::where('member_id', $request->id)->first();
        $ongkir = Ongkir::latest()->get();
        $isi = $request->baru;
        return view('kasir.member.ongkir', compact('ongkir',  'p', 'isi'));
    }

    public function update_ongkir(Request $request)
    {
        $om = Ongkirmember::findOrFail($request->id);
        $om->update([
            'ongkir_id' => $request->ido,
            'alamat' => $request->alamat,
            'sts_alamat' => $request->sts_alamat,
        ]);

        return response()->json();
    }

    public function detail(Request $request)
    {
        $m = Member::where('id', $request->id)->first();
        $p = Ongkirmember::where('member_id', $request->id)->latest('id', 'DESC')->limit(1)->first();
        $ongkirmem = Ongkirmember::where('member_id', $request->id)->get();
        return view('kasir.member.detail', compact('ongkirmem', 'm', 'p'));
    }

    public function destroy_all_member(Request $request)
    {
        $ids = $request->allVals;
        foreach ($ids as  $id) {
            Member::findOrFail($id)->delete();
        }

        return response()->json($ids);
    }

    public function cetak_kartu(Request $request)
    {
        $ids = $request->allVals;
        $kartu = [];
        foreach ($ids as $id) {
            $p = Member::where('id', $id)->first();
            $kartu[] = [
                'nama' =>  $p->nm_member,
                'kode' =>   $p->kd_member,
            ];
        }

        return view('kasir.member.kartu', compact('kartu'));
    }

    public function data_member()
    {
        $member = Member::pencarian()->latest()->paginate(10);
        $data = [
            'title' => 'Ramizah Store | Data Member',
            'page' => 'Data Member',
            'menuActive' => 'member',
            'menuOpen' => 'member',
        ];
        return view('admin.data.member', compact('data', 'member'))->with('no', 1);
    }
}
